<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('transactions', function (Blueprint $table) {
            if (!Schema::hasColumn('transactions', 'approval_status')) {
                $table->string('approval_status')->default('pending')->index()->after('status');
            }
            if (!Schema::hasColumn('transactions', 'approved_by')) {
                $table->unsignedBigInteger('approved_by')->nullable()->index()->after('approval_status');
            }
            if (!Schema::hasColumn('transactions', 'approved_at')) {
                $table->timestamp('approved_at')->nullable()->after('approved_by');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('transactions', function (Blueprint $table) {
            if (Schema::hasColumn('transactions', 'approved_at')) {
                $table->dropColumn('approved_at');
            }
            if (Schema::hasColumn('transactions', 'approved_by')) {
                $table->dropColumn('approved_by');
            }
            if (Schema::hasColumn('transactions', 'approval_status')) {
                $table->dropColumn('approval_status');
            }
        });
    }
};

